/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

/*
 * This is where the game map with actual information "there are
 * fighters here" is done.
 */
static void
update_game_surface (mod_gl_utils_context_t * utils_context,
		     SDL_Surface * surface,
		     lw6ker_game_state_t * game_state,
		     lw6gui_look_t * look, int x0, int y0, int w, int h)
{
  int x, y, z, x1, y1, d;
  int fighter_id, hidden;
  lw6ker_fighter_t *fighter;
  Uint32 color;
  float hidden_layer_alpha;

  hidden_layer_alpha = look->style.hidden_layer_alpha;
  x1 = x0 + w;
  y1 = y0 + h;
  d = game_state->map_state.shape.d;
  for (x = x0; x < x1; ++x)
    {
      for (y = y0; y < y1; ++y)
	{
	  fighter_id = -1;
	  hidden = 0;
	  for (z = 0; z < d && fighter_id < 0; ++z)
	    {
	      fighter_id =
		lw6ker_map_state_get_fighter_id (&(game_state->map_state),
						 x, y, z);
	      if (fighter_id < 0)
		{
		  hidden =
		    (lw6ker_map_struct_get_zone_id
		     (game_state->map_state.map_struct, x, y, z) < 0);
		}
	    }
	  if (fighter_id >= 0)
	    {
	      fighter = &(game_state->map_state.armies.fighters[fighter_id]);
	      color = mod_gl_utils_get_shaded_color_for_fighter
		(utils_context, fighter->team_color, fighter->health);
	      if (hidden)
		{
		  mod_gl_utils_force_color32_alpha (&color,
						    hidden_layer_alpha);
		}
	      mod_gl_utils_putpixel (surface, x - x0, y - y0, color);
	    }
	  else
	    {
	      mod_gl_utils_putpixel (surface, x - x0, y - y0, 0);
	    }
	}
    }
}

void
mod_gl_utils_update_game_texture (mod_gl_utils_context_t * utils_context,
				  SDL_Surface * surface,
				  GLuint texture,
				  lw6ker_game_state_t * game_state,
				  lw6gui_look_t * look)
{
  mod_gl_utils_update_team_color_map (&(utils_context->team_color_map),
				      &(look->style));
  update_game_surface (utils_context, surface, game_state, look,
		       0, 0, game_state->map_state.shape.w,
		       game_state->map_state.shape.h);
  /*
   * Using this instead of creating a new texture from a surface using
   * glTexImage2D (surface2texture) is important, for performance.
   * This is called at each display, we don't want a new texture to
   * be created each time: it's always the same size and represents
   * pretty much the same thing/layer -> where fighters are!
   */
  mod_gl_utils_texture_update (utils_context, texture, surface);
}

void
mod_gl_utils_update_game_texture_array (mod_gl_utils_context_t *
					utils_context,
					mod_gl_utils_surface_array_t *
					surface_array,
					mod_gl_utils_texture_array_t *
					texture_array,
					lw6ker_game_state_t * game_state,
					lw6gui_look_t * look)
{
  int n_x, n_y;

  if (utils_context->last_action.game_texture_array_update_id !=
      game_state->id
      || utils_context->last_action.game_texture_array_update_rounds !=
      game_state->rounds)
    {
      utils_context->last_action.game_texture_array_update_id =
	game_state->id;
      utils_context->last_action.game_texture_array_update_rounds =
	game_state->rounds;

      mod_gl_utils_update_team_color_map (&(utils_context->team_color_map),
					  &(look->style));

      for (n_y = 0; n_y < surface_array->layout.n_h; ++n_y)
	{
	  for (n_x = 0; n_x < surface_array->layout.n_w; ++n_x)
	    {
	      update_game_surface (utils_context,
				   mod_gl_utils_get_surface_array_surface
				   (surface_array, n_x, n_y), game_state,
				   look,
				   surface_array->layout.x0[n_x],
				   surface_array->layout.y0[n_y],
				   surface_array->layout.w[n_x],
				   surface_array->layout.h[n_y]);
	    }
	}

      /*
       * Now transform surfaces into textures.
       */
      mod_gl_utils_texture_array_update (utils_context, texture_array,
					 surface_array);
    }
  else
    {
      // same as before, no need to update
    }
}
