;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-config-set-string!
  (lambda (key value)
    (c-lw6cfg-set-option key value)
    )
  )

(define lw6-config-get-string
  (lambda (key)
    (c-lw6cfg-get-option key)
    )
  )

(define lw6-config-set-number!
  (lambda (key value)
    (begin
      (c-lw6cfg-set-option key (number->string value))
      )
    )
  )

(define lw6-config-get-number
  (lambda (key)
    (string->number (c-lw6cfg-get-option key))
    )
  )

(define lw6-config-set-boolean!
  (lambda (key value)
    (c-lw6cfg-set-option key (if value "true" "false"))
    )
  )

(define lw6-config-is-true?
  (lambda (key)
    (equal? (c-lw6cfg-get-option key) "true")
    )
  )

(define lw6-config-defaults
  (lambda ()
    (begin 
      (lw6-config-set-boolean! "fullscreen" #f)
      (lw6-config-set-number! "width" 640)
      (lw6-config-set-number! "height" 480)
      (lw6-config-set-number! "max-frames-per-sec" 60)
      (lw6-config-set-number! "max-logic-per-sec" 100)
      (lw6-config-set-number! "max-io-per-sec" 15)
      (lw6-config-set-number! "max-logic-per-display" 10)
      (lw6-config-set-number! "max-io-per-display" 2)
      (lw6-config-set-number! "checkpoint-delay" 1000)
      (lw6-config-set-string! "chosen-map" (string-append (c-lw6map-get-system-dir) "alpha/genuine-liquidwar/"))
      (lw6-config-set-string! "background-style" "water")
      (lw6-config-set-string! "hud-style" "floating")
      (lw6-config-set-string! "menu-style" "cylinder")
      (lw6-config-set-string! "view-style" "flat")
      )
    )
  )

(define lw6-update-config
  (lambda ()
    (begin
      (lw6-config-set-number! "min-msec-per-frame" (quotient 1000 (lw6-config-get-number "max-frames-per-sec")))
      (lw6-config-set-number! "min-msec-per-logic" (quotient 1000 (lw6-config-get-number "max-logic-per-sec")))
      (lw6-config-set-number! "min-msec-per-io" (quotient 1000 (lw6-config-get-number "max-io-per-sec")))
      )
    )
  )

(define lw6-load-config 
  (lambda () 
    (begin
      (lw6-config-defaults)
      (c-lw6cfg-parse-command-line)
      (c-lw6cfg-load (c-lw6cfg-get-default-system-config-file))
      (c-lw6cfg-parse-command-line)
      (c-lw6cfg-load (c-lw6cfg-get-default-user-config-file))
      (c-lw6cfg-parse-command-line)
      (lw6-update-config)
      )
    )
  )

(define lw6-save-config 
  (lambda () 
    (begin
      (c-lw6cfg-save (c-lw6cfg-get-default-user-config-file))
      )
    )
  )
