/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <stdio.h>
#include <libguile.h>
#include <locale.h>

#include "lib/liquidwar6.h"

static void *
guile_main (void *data)
{
  char *script = NULL;

  SCM_DEVAL_P = 1;
  SCM_BACKTRACE_P = 1;
  SCM_RECORD_POSITIONS_P = 1;
  SCM_RESET_DEBUG_MODE;

  lw6sys_log (LW6SYS_LOG_INFO, "",
	      _("registering C types and functions for Guile"));
  lw6_register_smobs ();
  lw6_register_funcs ();

  script = lw6_find_script ();
  lw6sys_log (LW6SYS_LOG_INFO, "", _("loading \"%s\""), script);
  scm_c_primitive_load (script);

  scm_gc ();

  lw6_quit_global ();

  return NULL;
}

/*
 * Start of program.
 * Liquid War 6 is basically only a scheme interpreter (using libguile)
 * which runs a scheme program, this program being itself fed by
 * C callbacks which provide access to graphical or high-level game
 * logic functions.
 */
int
main (int argc, char *argv[])
{
  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE_TARNAME, LW6_LOCALE_DIR);
  textdomain (PACKAGE_TARNAME);

  if (!lw6_process_basic_options (argc, argv))
    {
      if (lw6_init_global (argc, argv))
	{
	  scm_with_guile (guile_main, NULL);
	}

      lw6sys_check_malloc_free_count ();
      lw6sys_check_thread_count ();

      lw6sys_log (LW6SYS_LOG_INFO, "",
		  _
		  ("thanks for playing Liquid War 6 http://www.gnu.org/software/liquidwar6/"));
    }

  return 0;
}
