/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "sys.h"

void
lw6sys_serialize_int32 (unsigned char *data, LW6SYS_INT32 value)
{
  data[0] = value >> 24;
  data[1] = (value >> 16) & 0xFF;
  data[2] = (value >> 8) & 0xFF;
  data[3] = value & 0xFF;
}

LW6SYS_UINT32
lw6sys_unserialize_int32 (unsigned char *data)
{
  LW6SYS_INT32 ret;

  ret = (data[0] << 24) + (data[1] << 16) + (data[2] << 8) + data[3];

  return ret;
}

void
lw6sys_serialize_int16 (unsigned char *data, LW6SYS_INT16 value)
{
  data[0] = value >> 8;
  data[1] = value & 0xFF;
}

LW6SYS_UINT16
lw6sys_unserialize_int16 (unsigned char *data)
{
  LW6SYS_INT16 ret;

  ret = (data[0] << 8) + data[1];

  return ret;
}
