/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <errno.h>

#include "config.h"
#include "sys.h"
#include "sys-internal.h"

#define THREAD_JOIN_SLEEP 0.1f

static int mutex_lock_counter = 0;
static int mutex_unlock_counter = 0;

void *
lw6sys_mutex_create ()
{
  _LW6SYS_MUTEX *mutex;

  mutex = (_LW6SYS_MUTEX *) LW6SYS_CALLOC (sizeof (_LW6SYS_MUTEX));
  if (mutex)
    {
      if (!pthread_mutex_init (&(mutex->mutex), NULL))
	{
	  // OK
	}
      else
	{
	  // should never fail anyway...
	  LW6SYS_FREE (mutex);
	  mutex = NULL;
	}
    }

  if (!mutex)
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "sys", _("unable to create mutex"));
    }

  return (void *) mutex;
}

void
lw6sys_mutex_destroy (void *mutex)
{
  pthread_mutex_destroy (&(((_LW6SYS_MUTEX *) mutex)->mutex));
  LW6SYS_FREE (mutex);
}

int
lw6sys_mutex_lock (void *mutex)
{
  int ret = 0;
  int pthread_ret;

  pthread_ret = pthread_mutex_lock (&(((_LW6SYS_MUTEX *) mutex)->mutex));
  if (!pthread_ret)
    {
      mutex_lock_counter++;
      ret = 1;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "sys",
		  _("pthread_lock failed with error code %d"), pthread_ret);
    }

  return ret;
}

int
lw6sys_mutex_trylock (void *mutex)
{
  int ret = 0;
  int pthread_ret;

  pthread_ret = pthread_mutex_trylock (&(((_LW6SYS_MUTEX *) mutex)->mutex));
  if (!pthread_ret)
    {
      mutex_lock_counter++;
      ret = 1;
    }
  else
    {
      if (pthread_ret == EBUSY)
	{
	  // OK, we should just wait more
	}
      else
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, "sys",
		      _("pthread_trylock failed with error code %d"),
		      pthread_ret);
	}
    }

  return ret;
}

int
lw6sys_mutex_unlock (void *mutex)
{
  int ret = 0;
  int pthread_ret;

  pthread_ret = pthread_mutex_unlock (&(((_LW6SYS_MUTEX *) mutex)->mutex));
  if (!pthread_ret)
    {
      mutex_lock_counter++;
      ret = 1;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "sys",
		  _("pthread_unlock failed with error code %d"), pthread_ret);
    }

  return ret;
}

int
lw6sys_get_mutex_lock_count ()
{
  return mutex_lock_counter;
}

int
lw6sys_get_mutex_unlock_count ()
{
  return mutex_unlock_counter;
}

int
lw6sys_check_mutex_count ()
{
  int ret = 1;

  if (mutex_lock_counter != mutex_unlock_counter)
    {
      ret = 0;
      lw6sys_log (LW6SYS_LOG_WARNING, "sys",
		  _
		  ("possible mutex problem, %d mutexes have been locked, but only %d mutexes have been unlocked"),
		  mutex_lock_counter, mutex_unlock_counter);
    }

  return ret;
}
