/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "config.h"
#include "sys.h"

/*
 * Read all the contents of a file, put it in a dynamically
 * allocated string. You need to free the pointer afterwards.
 */
char *
lw6sys_read_file_content (char *filename)
{
  char *file_content = NULL;
  FILE *f;
  int size;
  size_t read = 0;

  f = fopen (filename, "r");
  if (f)
    {
      fseek (f, 0, SEEK_END);
      size = ftell (f);
      if (size >= 0)
	{
	  fseek (f, 0, SEEK_SET);
	  file_content = LW6SYS_CALLOC (size + 1);
	  if (file_content)
	    {
	      clearerr (f);
	      while ((!feof (f)) && (!ferror (f)))
		{
		  read += fread (file_content + read, sizeof (char), size, f);
		}
	      if (read != size)
		{
		  lw6sys_log (LW6SYS_LOG_WARNING, "sys",
			      _
			      ("couldn't read all of file \"%s\", size was supposed to be %d but only read %d"),
			      filename, size, read);
		}
	    }
	}
      fclose (f);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "sys",
		  _("can't open file \"%s\" for reading"), filename);
    }

  return file_content;
}
