/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6SND_CSOUND_INTERNAL_H
#define LIQUIDWAR6SND_CSOUND_INTERNAL_H

#include "../snd.h"

typedef struct _CSOUND_CONTEXT_STRUCT
{
  float volume;
}
_CSOUND_CONTEXT;

/*
 * In sound.c
 */
extern int _mod_csound_play_sound (_CSOUND_CONTEXT * snd_context,
				   int sound_id);

/*
 * In music.c
 */
extern int _mod_csound_play_music (_CSOUND_CONTEXT * snd_context,
				   char *music_name);

/*
 * In setup.c
 */
extern _CSOUND_CONTEXT *_mod_csound_init (float sound_volume,
					  float music_volume);
extern void _mod_csound_quit (_CSOUND_CONTEXT * snd_context);

/*
 * In volume.c
 */
extern void _mod_csound_set_sound_volume (_CSOUND_CONTEXT * snd_context,
					  float volume);
extern void _mod_csound_set_music_volume (_CSOUND_CONTEXT * snd_context,
					  float volume);

#endif
