/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "net.h"
#include "net-internal.h"

#define PROTOCOL_TIMEOUT_MSG "timeout"
#define PROTOCOL_ERROR_MSG "error"

int
lw6net_server_start (void *context, char *ip, int port)
{
  int ret = 0;
  _LW6NET_CONTEXT *net_context;

  net_context = (_LW6NET_CONTEXT *) context;
  lw6sys_log (LW6SYS_LOG_INFO, "net", _("starting server on \"%s:%d\""), ip,
	      port);

  net_context->server_sock = lw6net_socket_listen (context, ip, port);

  ret = (net_context->server_sock >= 0);

  return ret;
}

int
lw6net_server_poll (void *context, LW6MAP_MAP * map,
		    LW6KER_GAME_STATE * game_state)
{
  int ret = 0;
  _LW6NET_CONTEXT *net_context;
  int accept_sock;
  char *ip = NULL;
  int port = 0;

  net_context = (_LW6NET_CONTEXT *) context;

  if (net_context->server_sock >= 0)
    {
      _lw6net_screenshot_refresh (net_context, &(net_context->screenshot),
				  map, game_state);

      accept_sock = lw6net_socket_accept (net_context, &ip,
					  &port, net_context->server_sock,
					  0.0f);

      if (accept_sock >= 0)
	{
	  _lw6net_server_handle (net_context, map, game_state, accept_sock,
				 ip, port);
	}
      if (ip)
	{
	  LW6SYS_FREE (ip);
	}
    }

  _lw6net_thread_vacuum (context);

  return ret;
}

void
lw6net_server_stop (void *context)
{
  _LW6NET_CONTEXT *net_context;

  net_context = (_LW6NET_CONTEXT *) context;
  if (net_context->server_sock >= 0)
    {
      lw6net_socket_close (context, net_context->server_sock);
    }
}

static void
handle_callback_func (void *callback_data)
{
  int protocol = _LW6NET_PROTOCOL_UNKNOWN;
  _LW6NET_SERVER_HANDLE_DATA *handle_data;

  handle_data = (_LW6NET_SERVER_HANDLE_DATA *) callback_data;

  lw6sys_log (LW6SYS_LOG_INFO, "net", _("handle request from \"%s:%d\""),
	      handle_data->ip, handle_data->port);

  protocol =
    _lw6net_get_protocol ((void *) handle_data->context, handle_data->sock);

  switch (protocol)
    {
    case _LW6NET_PROTOCOL_HTTP:
      _lw6net_httpd_respond (handle_data);
      break;
    case _LW6NET_PROTOCOL_LW6:
      lw6net_send_line ((void *) handle_data->context, handle_data->sock,
			"LW6 not implemented");
      break;
    case _LW6NET_PROTOCOL_UNKNOWN:
      lw6net_send_line ((void *) handle_data->context, handle_data->sock,
			PACKAGE_TARNAME "-" PACKAGE_VERSION ": "
			PROTOCOL_TIMEOUT_MSG);
      break;
    default:
      lw6net_send_line ((void *) handle_data->context, handle_data->sock,
			PACKAGE_TARNAME "-" PACKAGE_VERSION ": "
			PROTOCOL_ERROR_MSG);
      break;
    }
}

static void
handle_callback_join (void *callback_data)
{
  _LW6NET_SERVER_HANDLE_DATA *handle_data;

  handle_data = (_LW6NET_SERVER_HANDLE_DATA *) callback_data;

  if (handle_data)
    {
      if (handle_data->sock >= 0)
	{
	  lw6net_socket_close ((void *) handle_data->context,
			       handle_data->sock);
	}
      if (handle_data->map_title)
	{
	  LW6SYS_FREE (handle_data->map_title);
	}
      LW6SYS_FREE (handle_data);
    }
}

int
_lw6net_server_handle (_LW6NET_CONTEXT * net_context, LW6MAP_MAP * map,
		       LW6KER_GAME_STATE * game_state, int sock, char *ip,
		       int port)
{
  int ret = 0;
  _LW6NET_SERVER_HANDLE_DATA *handle_data;
  void *handle;

  handle_data =
    (_LW6NET_SERVER_HANDLE_DATA *)
    LW6SYS_CALLOC (sizeof (_LW6NET_SERVER_HANDLE_DATA));
  if (handle_data)
    {
      handle_data->context = (void *) net_context;
      strncpy (handle_data->ip, ip, _LW6NET_IP_SIZE);
      handle_data->port = port;
      handle_data->sock = sock;
      handle_data->playing = (game_state != NULL);
      if (map && map->metadata.title)
	{
	  handle_data->map_title = lw6sys_str_copy (map->metadata.title);
	}

      handle =
	lw6sys_thread_create (&handle_callback_func, &handle_callback_join,
			      (void *) handle_data, _LW6NET_FLAG_VACUUM);
      if (handle)
	{
	  _lw6net_thread_register ((_LW6NET_CONTEXT *) net_context, handle);
	  ret = 1;
	}
    }

  return ret;
}
