/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "net.h"
#include "net-internal.h"

#define CHAR_CR '\x0d'
#define CHAR_LF '\x0a'
#define CHAR_0 '\0'
#define TRAIL_SIZE 2

char *
lw6net_recv_line (void *context, int sock)
{
  char *ret = NULL;
  int line_size = 0;
  float line_delay;
  int wanted_size;
  int available_size;
  int trail_size;
  char *pos_lf;
  char *line_buf = NULL;

  if (sock >= 0)
    {
      line_size = ((_LW6NET_CONTEXT *) context)->const_data.line_size;
      line_delay = ((_LW6NET_CONTEXT *) context)->const_data.line_delay;
      line_buf = LW6SYS_CALLOC (line_size + 3);
      if (line_buf)
	{
	  available_size =
	    lw6net_socket_peek (context, sock, line_buf, line_size + 2, 0.0f);
	  if (available_size > 0)
	    {
	      pos_lf = strchr (line_buf, CHAR_LF);
	      if (pos_lf)
		{
		  trail_size = (pos_lf > line_buf
				&& pos_lf[-1] == CHAR_CR) ? 2 : 1;
		  wanted_size = (pos_lf + 1 - line_buf);
		  pos_lf[1 - trail_size] = CHAR_0;
		  ret = lw6sys_str_copy (line_buf);
		  if (ret)
		    {
		      lw6sys_str_cleanup (ret);
		    }

		  // remove data from queue
		  lw6net_socket_recv (context, sock, line_buf, wanted_size,
				      line_delay, 0);
		}
	    }
	  LW6SYS_FREE (line_buf);
	}
    }

  return ret;
}

int
lw6net_send_line (void *context, int sock, char *line)
{
  int ret = 0;
  int line_size = 0;
  float line_delay;
  int wanted_size = 0;
  char trail[TRAIL_SIZE + 1] = { CHAR_CR, CHAR_LF, CHAR_0 };

  if (sock >= 0 && line)
    {
      line_size = ((_LW6NET_CONTEXT *) context)->const_data.line_size;
      line_delay = ((_LW6NET_CONTEXT *) context)->const_data.line_delay;
      wanted_size = strlen (line);
      if (wanted_size > line_size)
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, "net",
		      _("stripping line \"%s\" of size %d, limit is %d"),
		      line, wanted_size, line_size);
	  wanted_size = line_size;
	}

      ret =
	lw6net_socket_send (context, sock, line, wanted_size, line_delay, 0)
	&& lw6net_socket_send (context, sock, trail, TRAIL_SIZE, line_delay,
			       0);
    }

  return ret;
}
