/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "net.h"
#include "net-internal.h"

int
_lw6net_httpd_init (_LW6NET_CONTEXT * net_context)
{
  int ret = 0;

  lw6net_clear_log ();

  ret = 1;

  return ret;
}

void
_lw6net_httpd_quit (_LW6NET_CONTEXT * net_context)
{

}

int
_lw6net_httpd_respond (_LW6NET_SERVER_HANDLE_DATA * handle_data)
{
  int ret = 0;
  int blank_received = 0;
  char *request_line = NULL;
  char *header_line = NULL;
  _LW6NET_HTTP_METHOD http_method = _LW6NET_HTTP_METHOD_GET;
  char *request_uri = NULL;
  LW6SYS_ASSOC *params = NULL;
  _LW6NET_HTTPD_LOG_ENTRY httpd_log_entry;

  memset (&httpd_log_entry, 0, sizeof (_LW6NET_HTTPD_LOG_ENTRY));
  httpd_log_entry.ip = handle_data->ip;
  httpd_log_entry.user = "-";

  // todo
  request_line =
    lw6net_recv_line ((void *) handle_data->context, handle_data->sock);
  if (request_line)
    {
      httpd_log_entry.request = request_line;

      ret =
	_lw6net_http_request_parse (handle_data, &http_method, &request_uri,
				    &params, request_line, &httpd_log_entry);
      while (!blank_received)
	{
	  header_line =
	    lw6net_recv_line ((void *) handle_data->context,
			      handle_data->sock);
	  if (header_line)
	    {
	      if (lw6sys_str_is_blank (header_line))
		{
		  blank_received = 1;
		}
	      LW6SYS_FREE (header_line);
	    }
	}
    }

  if (ret && request_uri)
    {
      if ((!strcmp (request_uri, handle_data->context->const_data.uri_root))
	  ||
	  (!strcmp (request_uri, handle_data->context->const_data.uri_index)))
	{
	  _lw6net_template_params (handle_data, &params);
	  _lw6net_http_response_send_template (handle_data,
					       handle_data->context->
					       const_data.uri_index, params,
					       &httpd_log_entry);
	}
      else
	if (!strcmp (request_uri, handle_data->context->const_data.uri_more))
	{
	  _lw6net_template_params (handle_data, &params);
	  _lw6net_http_response_send_template (handle_data,
					       request_uri, params,
					       &httpd_log_entry);
	}
      else
	if (!strcmp
	    (request_uri, handle_data->context->const_data.uri_screenshot))
	{
	  char *screenshot_path;
	  screenshot_path = lw6net_screenshot_get_default_jpeg ();
	  if (screenshot_path)
	    {
	      _lw6net_http_response_send_absolute_file (handle_data,
							handle_data->context->
							const_data.
							content_type_jpeg,
							screenshot_path,
							handle_data->context->
							screenshot.mutex,
							&httpd_log_entry);

	      LW6SYS_FREE (screenshot_path);
	    }
	}
      else
	if (!strcmp
	    (request_uri, handle_data->context->const_data.uri_robots))
	{
	  _lw6net_http_response_send_file (handle_data,
					   handle_data->context->const_data.
					   content_type_txt, request_uri,
					   &httpd_log_entry);
	}
      else
	if (!strcmp
	    (request_uri, handle_data->context->const_data.uri_favicon))
	{
	  _lw6net_http_response_send_file (handle_data,
					   handle_data->context->const_data.
					   content_type_ico, request_uri,
					   &httpd_log_entry);
	}
      else
	if (!strcmp (request_uri, handle_data->context->const_data.uri_style))
	{
	  _lw6net_http_response_send_file (handle_data,
					   handle_data->context->const_data.
					   content_type_css, request_uri,
					   &httpd_log_entry);
	}
      else
	if (!strcmp (request_uri, handle_data->context->const_data.uri_gnu))
	{
	  _lw6net_http_response_send_file (handle_data,
					   handle_data->context->const_data.
					   content_type_jpeg, request_uri,
					   &httpd_log_entry);
	}
      else
	if (!strcmp (request_uri, handle_data->context->const_data.uri_gpl))
	{
	  _lw6net_http_response_send_file (handle_data,
					   handle_data->context->const_data.
					   content_type_txt, request_uri,
					   &httpd_log_entry);
	}
      else
	{
	  _lw6net_http_response_send_error (handle_data, 404,
					    &httpd_log_entry);
	}
    }
  else
    {
      _lw6net_http_response_send_error (handle_data, 500, &httpd_log_entry);
    }

  _lw6net_httpd_log (handle_data, &httpd_log_entry);

  if (request_line)
    {
      LW6SYS_FREE (request_line);
    }
  if (request_uri)
    {
      LW6SYS_FREE (request_uri);
    }
  if (params)
    {
      lw6sys_assoc_free (params);
    }

  return ret;
}
