/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <dirent.h>
#include <string.h>
#include <stdio.h>

#include "config.h"
#include "map.h"
#include "map-internal.h"

#define MAP_DIR_1 "map/"
#define MAP_DIR_2 "data/map/"
#define MAP_DIR_3 "../data/map/"
#define MAP_DIR_4 LW6_DATA_DIR "map/"
#define MAP_DIR_5 LW6_TOP_SRC_DIR "data/map/"
#define MAP_DIR_DEFAULT LW6_DATA_DIR "map/"
#define MAP_TEST "alpha/genuine-liquidwar/" LW6MAP_FILE_MAP_PNG

/*
 * Returns the path where the system maps are.
 * Returned pointer does not need to be freed.
 */
char *
lw6map_get_system_dir ()
{
  char *ret = NULL;

  if (lw6sys_file_exists (MAP_DIR_1 MAP_TEST))
    {
      ret = MAP_DIR_1;
    }
  else if (lw6sys_file_exists (MAP_DIR_2 MAP_TEST))
    {
      ret = MAP_DIR_2;
    }
  else if (lw6sys_file_exists (MAP_DIR_3 MAP_TEST))
    {
      ret = MAP_DIR_3;
    }
  else if (lw6sys_file_exists (MAP_DIR_4 MAP_TEST))
    {
      ret = MAP_DIR_4;
    }
  else if (lw6sys_file_exists (MAP_DIR_5 MAP_TEST))
    {
      ret = MAP_DIR_5;
    }
  if (!ret)
    {
      ret = MAP_DIR_DEFAULT;
    }

  return ret;
}

static LW6MAP_ENTRY *
new_entry (char *dir, char *d_name)
{
  LW6MAP_ENTRY *entry = NULL;
  char *title = NULL;
  char *path = NULL;
  int subdir = 0;
  int map_exists = 0;
  int path_length =
    strlen (dir) + strlen (d_name) + 1 + strlen (LW6MAP_FILE_MAP_PNG);
  int ok = 0;

  title = lw6sys_str_copy (d_name);
  if (title)
    {
      path = LW6SYS_MALLOC (path_length + 1);
      if (path)
	{
	  snprintf (path, path_length + 1, "%s%s", dir, d_name);
	  path[path_length] = '\0';
	  subdir = lw6sys_dir_exists (path);
	  snprintf (path, path_length + 1, "%s%s/" LW6MAP_FILE_MAP_PNG, dir,
		    d_name);
	  path[path_length] = '\0';
	  map_exists = lw6sys_file_exists (path);
	  if (map_exists || (subdir && title[0] != '.'))
	    {
	      /*
	       * We keep the same buffer to store the directory name,
	       * it's necessarly big enough to store the directory
	       * if it could append map.png to it the first place...
	       */
	      snprintf (path, path_length + 1, "%s%s/", dir, d_name);
	      path[path_length] = '\0';

	      entry = LW6SYS_MALLOC (sizeof (LW6MAP_ENTRY));
	      if (entry)
		{
		  entry->title = title;
		  entry->path = path;
		  entry->subdir = !map_exists;
		  ok = 1;
		}
	    }
	}
    }

  if (!ok)
    {
      if (title)
	{
	  LW6SYS_FREE (title);
	}
      if (path)
	{
	  LW6SYS_FREE (path);
	}
      if (entry)
	{
	  LW6SYS_FREE (entry);
	}
    }

  return entry;
}

static void
free_entry_callback (void *data)
{
  lw6map_free_entry ((LW6MAP_ENTRY *) data);
}

void
lw6map_free_entry (LW6MAP_ENTRY * entry)
{
  if (entry)
    {
      LW6SYS_FREE (entry->title);
      LW6SYS_FREE (entry->path);
    }
  LW6SYS_FREE (entry);
}

static LW6SYS_LIST *
get_subdirs (char *dir)
{
  LW6SYS_LIST *list = NULL;

  struct dirent **namelist;
  int n;

  /*
   * OK I acknowledge it's not very elegant to do this here.
   * Ideally we would have some code that checks the existence
   * of map.png, checks the content of the directory *within*
   * liquidwar6map and then call this from here. Point is we'll
   * end up re-inventing scandir... Whenever this code gets
   * more complex it should be completely rewritten and moved
   * elsewhere. It shouldn't be that hard to pass some
   * list of strings.
   */
  n = scandir (dir, &namelist, NULL, alphasort);
  if (n < 0)
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "", _("couldn't read map dir \"%s\""),
		  dir);
    }
  else
    {
      list = lw6sys_list_new (free_entry_callback);
      if (list)
	{
	  if (n > 0)
	    {
	      while (n--)
		{
		  LW6MAP_ENTRY *entry = new_entry (dir, namelist[n]->d_name);
		  if (entry)
		    {
		      lw6sys_list_push (&list, (void *) entry);
		    }
		  free (namelist[n]);	// use of free instead of LW6SYS_FREE is "normal" here       
		}
	    }
	  else
	    {
	      lw6sys_log (LW6SYS_LOG_WARNING, "map",
			  _("no maps in dir \"%s\""), dir);
	    }
	}
      free (namelist);		// use of free instead of LW6SYS_FREE is "normal" here
    }

  return list;
}

/*
 * Returns a list of LW6MAP_ENTRY elements, which
 * describe what maps are in a directory.
 */
LW6SYS_LIST *
lw6map_get_maps (char *dir)
{
  return get_subdirs (dir);
}
