/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "ker.h"
#include "ker-internal.h"

/*
 * FIGHTER_MOVE_? offset or used when moving fighters,
 * and calculating "what's in that direction?".
 */
LW6SYS_INT32 _LW6KER_FIGHTER_MOVE_X_OFFSET[LW6KER_NB_DIRS] =
  { 0, 1, 1, 1, 1, 0, 0, -1, -1, -1, -1, 0 };
LW6SYS_INT32 _LW6KER_FIGHTER_MOVE_Y_OFFSET[LW6KER_NB_DIRS] =
  { -1, -1, 0, 0, 1, 1, 1, 1, 0, 0, -1, -1 };

void
_lw6ker_fighter_clear (LW6KER_FIGHTER * fighter)
{
  memset (fighter, 0, sizeof (LW6KER_FIGHTER));
}

void
_lw6ker_fighter_update_checksum (LW6KER_FIGHTER * fighter,
				 LW6SYS_UINT32 * checksum)
{
  lw6sys_checksum_update_int32 (checksum, fighter->team_id);
  lw6sys_checksum_update_int32 (checksum, fighter->layer);
  lw6sys_checksum_update_int32 (checksum, fighter->last_direction);
  lw6sys_checksum_update_int32 (checksum, fighter->health);
  lw6sys_checksum_update_xy (checksum, &(fighter->pos));
}

void
_lw6ker_fighter_print_debug (LW6KER_FIGHTER * fighter)
{
  lw6sys_log (LW6SYS_LOG_DEBUG, "ker",
	      _
	      ("fighter team_id=%d, layer=%d, last_direction=%d, health=%d, x=%d, y=%d"),
	      fighter->team_id, fighter->layer, fighter->last_direction,
	      fighter->health, (int) fighter->pos.x, (int) fighter->pos.y);
}

void
_lw6ker_fighter_move (LW6KER_FIGHTER * fighter,
		      LW6SYS_INT32 fighter_id,
		      LW6SYS_INT32 layer, LW6SYS_INT32 x,
		      LW6SYS_INT32 y, LW6KER_MAP_STATE * map_state)
{
  lw6ker_map_state_set_fighter_id (map_state, fighter->layer,
				   fighter->pos.x, fighter->pos.y, -1);
  fighter->layer = layer;
  fighter->pos.x = x;
  fighter->pos.y = y;
  lw6ker_map_state_set_fighter_id (map_state, layer, x, y, fighter_id);
}

void
_lw6ker_fighter_attack (LW6KER_FIGHTER * fighter,
			LW6SYS_INT32 fighter_id,
			LW6SYS_INT32 layer, LW6SYS_INT32 x,
			LW6SYS_INT32 y, LW6KER_MAP_STATE * map_state,
			LW6SYS_INT32 fighter_attack,
			LW6SYS_INT32 fighter_new_health)
{
  LW6KER_FIGHTER *enemy;

  enemy = lw6ker_map_state_get_fighter_unsafe (map_state, layer, x, y);
  enemy->health -= fighter_attack;
  if (enemy->health <= 0 || enemy->health > LW6OPT_MAX_FIGHTER_HEALTH)
    {
      /*
       * Reflect changes in pre-calculated values
       */
      (map_state->armies.fighters_per_team[fighter->team_id])++;
      (map_state->armies.fighters_per_team[enemy->team_id])--;
      /*
       * Give the conquered enemy some health
       */
      enemy->health = fighter_new_health;
      /*
       * Change it to our team
       */
      enemy->team_id = fighter->team_id;
    }
}

void
_lw6ker_fighter_defend (LW6KER_FIGHTER * fighter,
			LW6SYS_INT32 fighter_id,
			LW6SYS_INT32 layer, LW6SYS_INT32 x,
			LW6SYS_INT32 y,
			LW6KER_MAP_STATE * map_state,
			LW6SYS_INT32 fighter_defense)
{
  LW6KER_FIGHTER *ally;

  ally = lw6ker_map_state_get_fighter_unsafe (map_state, layer, x, y);
  ally->health += fighter_defense;
  if (ally->health > LW6OPT_MAX_FIGHTER_HEALTH || ally->health <= 0)
    {
      ally->health = LW6OPT_MAX_FIGHTER_HEALTH;
    }
}
