/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_MOD_GL_INTERNAL_H
#define LIQUIDWAR6GFX_MOD_GL_INTERNAL_H

#include <GL/gl.h>
#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>

#include "../gfx.h"
#include "gl-utils/gl-utils.h"
#include "gl-background/gl-background.h"
#include "gl-hud/gl-hud.h"
#include "gl-menu/gl-menu.h"
#include "gl-view/gl-view.h"

typedef struct _MOD_GL_CONTEXT_STRUCT
{
  MOD_GL_UTILS_CONTEXT utils_context;
  MOD_GL_BACKGROUND_BACKEND *background_backend;
  MOD_GL_HUD_BACKEND *hud_backend;
  MOD_GL_MENU_BACKEND *menu_backend;
  MOD_GL_VIEW_BACKEND *view_backend;
}
_MOD_GL_CONTEXT;

/*
 * In setup.c
 */
extern _MOD_GL_CONTEXT *_mod_gl_init (int width, int height, int fullscreen,
				      void (*resize_callback) (int width,
							       int height,
							       int
							       fullscreen),
				      int ticks);
extern void _mod_gl_quit (_MOD_GL_CONTEXT * gfx_context);
extern int _mod_gl_set_background_backend (_MOD_GL_CONTEXT * gfx_context,
					   char *background_style);
extern int _mod_gl_set_hud_backend (_MOD_GL_CONTEXT * gfx_context,
				    char *hud_style);
extern int _mod_gl_set_menu_backend (_MOD_GL_CONTEXT * gfx_context,
				     char *menu_style);
extern int _mod_gl_set_view_backend (_MOD_GL_CONTEXT * gfx_context,
				     char *view_style);

#endif
