/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>

#include <string.h>

#include "config.h"
#include "../gfx.h"
#include "mod-gl.h"
#include "mod-gl-internal.h"


static void
display_background (void *gfx_context, char *skin)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_background_backend (mod_gl_context, skin);

      mod_gl_background_display (&(mod_gl_context->utils_context),
				 mod_gl_context->background_backend);
    }
}

static void
display_hud (void *gfx_context, LW6KER_GAME_STATE * game_state,
	     LW6GFX_HUD_STEP step, char *skin)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_hud_backend (mod_gl_context, skin);

      mod_gl_hud_display (&(mod_gl_context->utils_context),
			  mod_gl_context->hud_backend, game_state, step);
    }
}

static void
display_hud_preview (void *gfx_context, LW6GFX_HUD_STEP step, char *skin)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_hud_backend (mod_gl_context, skin);

      mod_gl_hud_display_preview (&(mod_gl_context->utils_context),
				  mod_gl_context->hud_backend, step);
    }
}

static int
poll_keypress (void *gfx_context, LW6GFX_KEYPRESS * keypress)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_poll_keypress (&(mod_gl_context->utils_context),
					keypress);
    }

  return ret;
}

static int
is_key_esc (void *gfx_context, int keysym)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_esc (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_up (void *gfx_context, int keysym)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_is_key_up (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_down (void *gfx_context, int keysym)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_down (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_left (void *gfx_context, int keysym)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_left (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_right (void *gfx_context, int keysym)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_right (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_enter (void *gfx_context, int keysym)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_enter (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_del (void *gfx_context, int keysym)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_del (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_backspace (void *gfx_context, int keysym)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_backspace (&(mod_gl_context->utils_context),
				       keysym);
    }

  return ret;
}

static int
is_key_help (void *gfx_context, int keysym)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_help (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_quit (void *gfx_context, int keysym)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_quit (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
poll_quit (void *gfx_context)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_poll_quit (&(mod_gl_context->utils_context));
    }

  return ret;
}

static void
send_quit (void *gfx_context)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_send_quit (&(mod_gl_context->utils_context));
    }
}

static int
get_key_state (void *gfx_context, int keysym)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_get_key_state (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
poll_mouse_move (void *gfx_context, int *x, int *y)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_mouse_move (&(mod_gl_context->utils_context), x, y);
    }

  return ret;
}

static int
poll_mouse_button (void *gfx_context, int button)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_mouse_button (&(mod_gl_context->utils_context),
					button);
    }

  return ret;
}

static void
get_mouse_state (void *gfx_context, int *x, int *y, int *button_left,
		 int *button_right)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_get_mouse_state (&(mod_gl_context->utils_context), x, y,
				    button_left, button_right);
    }
}

static void
display_sysinfo (void *gfx_context, int fps, int rps,
		 int bytes_in, int bytes_out)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_display_sysinfo (&(mod_gl_context->utils_context), fps,
				    rps, bytes_in, bytes_out);
    }
}

static void
display_log (void *gfx_context, char **log)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_display_log (&(mod_gl_context->utils_context), log);
    }
}

static void
display_time (void *gfx_context, long long seconds)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_display_time (&(mod_gl_context->utils_context), seconds);
    }
}

static void
display_version (void *gfx_context)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_display_version (&(mod_gl_context->utils_context));
    }
}

static void
display_map_preview (void *gfx_context, LW6MAP_MAP * map, char *skin)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_view_backend (mod_gl_context, skin);

      mod_gl_view_display_preview (&(mod_gl_context->utils_context),
				   mod_gl_context->view_backend, map);
    }
}

static void
display_map_zones (void *gfx_context, LW6MAP_MAP * map,
		   LW6KER_MAP_STRUCT * map_struct, char *skin)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_view_backend (mod_gl_context, skin);

      mod_gl_view_display_zones (&(mod_gl_context->utils_context),
				 mod_gl_context->view_backend, map,
				 map_struct);
    }
}

static void
display_map_gradient (void *gfx_context, LW6MAP_MAP * map,
		      LW6KER_MAP_STATE * map_state, int team_id, char *skin)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_view_backend (mod_gl_context, skin);

      mod_gl_view_display_gradient (&(mod_gl_context->utils_context),
				    mod_gl_context->view_backend, map,
				    map_state, team_id);
    }
}

static void
display_game (void *gfx_context, LW6MAP_MAP * map,
	      LW6KER_GAME_STATE * game_state, LW6GFX_GAME_LOOK * game_look,
	      char *skin)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_view_backend (mod_gl_context, skin);

      mod_gl_view_display_game (&(mod_gl_context->utils_context),
				mod_gl_context->view_backend, map, game_state,
				game_look);
    }
}

static void
pick_map_coord (void *gfx_context, int *map_x, int *map_y,
		LW6MAP_MAP * map, LW6KER_GAME_STATE * game_state,
		int screen_x, int screen_y, char *skin)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_view_backend (mod_gl_context, skin);

      mod_gl_view_pick_map_coord (&(mod_gl_context->utils_context),
				  mod_gl_context->view_backend, map_x, map_y,
				  map, game_state, screen_x, screen_y);
    }
}

static void
display_menu (void *gfx_context, LW6GFX_MENU * menu, char *skin)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_menu_backend (mod_gl_context, skin);

      mod_gl_menu_display (&(mod_gl_context->utils_context),
			   mod_gl_context->menu_backend, menu);
    }
}

static int
pick_menuitem (void *gfx_context, LW6GFX_MENU * menu, int x, int y,
	       char *skin)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_menu_backend (mod_gl_context, skin);

      ret = mod_gl_menu_pick_item (&(mod_gl_context->utils_context),
				   mod_gl_context->menu_backend, menu, x, y);
    }

  return ret;
}

static void
prepare_buffer (void *gfx_context)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_prepare_buffer (&(mod_gl_context->utils_context));
    }
}

static void
swap_buffers (void *gfx_context)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_swap_buffers (&(mod_gl_context->utils_context));
    }
}

static void *
init (int width, int height, int fullscreen,
      void (*resize_callback) (int width, int height, int fullscreen),
      int ticks)
{
  _MOD_GL_CONTEXT *mod_gl_context =
    _mod_gl_init (width, height, fullscreen, resize_callback, ticks);

  return (void *) mod_gl_context;
}

static int
set_video_mode (void *gfx_context, int width, int height,
		int fullscreen,
		void (*resize_callback) (int width,
					 int height, int fullscreen))
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_set_video_mode (&(mod_gl_context->utils_context), width,
				     height, fullscreen, resize_callback);
    }

  return ret;
}

static void
quit (void *gfx_context)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_quit (mod_gl_context);
    }
}

static void
delay (void *gfx_context, int ms)
{
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_delay (&(mod_gl_context->utils_context), ms);
    }
}

static int
get_ticks (void *gfx_context)
{
  int ret = 0;
  _MOD_GL_CONTEXT *mod_gl_context = (_MOD_GL_CONTEXT *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_get_ticks (&(mod_gl_context->utils_context));
    }

  return ret;
}

LW6GFX_BACKEND *
mod_gl_create_backend ()
{
  LW6GFX_BACKEND *backend;

  backend = LW6SYS_MALLOC (sizeof (LW6GFX_BACKEND));
  if (backend)
    {
      memset (backend, 0, sizeof (LW6GFX_BACKEND));

      backend->display_background = display_background;
      backend->display_hud = display_hud;
      backend->display_hud_preview = display_hud_preview;
      backend->poll_keypress = poll_keypress;
      backend->is_key_esc = is_key_esc;
      backend->is_key_up = is_key_up;
      backend->is_key_down = is_key_down;
      backend->is_key_left = is_key_left;
      backend->is_key_right = is_key_right;
      backend->is_key_enter = is_key_enter;
      backend->is_key_del = is_key_del;
      backend->is_key_backspace = is_key_backspace;
      backend->is_key_help = is_key_help;
      backend->is_key_quit = is_key_quit;
      backend->poll_quit = poll_quit;
      backend->send_quit = send_quit;
      backend->get_key_state = get_key_state;
      backend->poll_mouse_move = poll_mouse_move;
      backend->poll_mouse_button = poll_mouse_button;
      backend->get_mouse_state = get_mouse_state;
      backend->display_sysinfo = display_sysinfo;
      backend->display_log = display_log;
      backend->display_time = display_time;
      backend->display_version = display_version;
      backend->display_map_preview = display_map_preview;
      backend->display_map_zones = display_map_zones;
      backend->display_map_gradient = display_map_gradient;
      backend->display_game = display_game;
      backend->pick_map_coord = pick_map_coord;
      backend->display_menu = display_menu;
      backend->pick_menuitem = pick_menuitem;
      backend->prepare_buffer = prepare_buffer;
      backend->swap_buffers = swap_buffers;
      backend->init = init;
      backend->set_video_mode = set_video_mode;
      backend->quit = quit;
      backend->delay = delay;
      backend->get_ticks = get_ticks;
    }

  return backend;
}
