/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include <GL/glu.h>

#include "config.h"
#include "../../../gfx.h"
#include "gl-flat.h"
#include "gl-flat-internal.h"

int
_mod_gl_view_flat_game_context_init (MOD_GL_UTILS_CONTEXT *
				     utils_context,
				     _MOD_GL_VIEW_FLAT_CONTEXT *
				     flat_context,
				     _MOD_GL_VIEW_FLAT_GAME_CONTEXT *
				     game_context,
				     LW6MAP_MAP * map,
				     LW6KER_GAME_STATE * game_state,
				     LW6GFX_GAME_LOOK * game_look)
{
  int ret = 0;

  ret =
    _mod_gl_view_flat_game_context_init_map (utils_context, flat_context,
					     &(game_context->map), map)
    && _mod_gl_view_flat_game_context_init_armies (utils_context,
						   flat_context,
						   &(game_context->armies),
						   game_state, game_look);

  return ret;
}

int
_mod_gl_view_flat_game_context_init_map (MOD_GL_UTILS_CONTEXT *
					 utils_context,
					 _MOD_GL_VIEW_FLAT_CONTEXT *
					 flat_context,
					 _MOD_GL_VIEW_FLAT_GAME_CONTEXT_MAP *
					 game_context_map, LW6MAP_MAP * map)
{
  int ret = 0;

  ret = 1;

  MOD_GL_UTILS_SURFACE_ARRAY surface_array;

  memset (&surface_array, 0, sizeof (MOD_GL_UTILS_SURFACE_ARRAY));

  ret = ret && mod_gl_utils_surface_array_init_from_map (utils_context,
							 &surface_array,
							 map,
							 flat_context->
							 const_data.
							 tile_size_map);
  if (ret)
    {
      ret = mod_gl_utils_texture_array_init (utils_context,
					     &(game_context_map->
					       map_texture_array),
					     map->texture.shape.w,
					     map->texture.shape.h,
					     flat_context->const_data.
					     tile_size_map);
      if (ret)
	{
	  mod_gl_utils_texture_array_update (utils_context,
					     &(game_context_map->
					       map_texture_array),
					     &surface_array);
	}
      mod_gl_utils_surface_array_clear (utils_context, &surface_array);
    }

  game_context_map->map = map;
  game_context_map->map_id = map->id;

  if (!ret)
    {

      lw6sys_log (LW6SYS_LOG_WARNING, "gfx-mod-gl",
		  _("unable to init game_context (map) for flat backend"));
    }

  return ret;
}

int
_mod_gl_view_flat_game_context_init_armies (MOD_GL_UTILS_CONTEXT *
					    utils_context,
					    _MOD_GL_VIEW_FLAT_CONTEXT *
					    flat_context,
					    _MOD_GL_VIEW_FLAT_GAME_CONTEXT_ARMIES
					    * game_context_armies,
					    LW6KER_GAME_STATE * game_state,
					    LW6GFX_GAME_LOOK * game_look)
{
  int ret = 0;
  int i;

  ret = 1;

  ret = ret
    && mod_gl_utils_surface_array_init (utils_context,
					&(game_context_armies->
					  armies_surface_array),
					game_state->map.shape.w,
					game_state->map.shape.h,
					flat_context->const_data.
					tile_size_armies);

  for (i = 0; i < game_state->map.nb_layers; ++i)
    {
      ret = ret
	&& mod_gl_utils_texture_array_init (utils_context,
					    &(game_context_armies->
					      armies_texture_arrays[i]),
					    game_state->map.shape.w,
					    game_state->map.shape.h,
					    flat_context->const_data.
					    tile_size_armies);
    }

  game_context_armies->game_state = game_state;
  game_context_armies->game_state_id = game_state->id;

  if (!ret)
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "gfx-mod-gl",
		  _("unable to init game_context (armies) for flat backend"));
    }

  return ret;
}

void
_mod_gl_view_flat_game_context_clear (MOD_GL_UTILS_CONTEXT *
				      utils_context,
				      _MOD_GL_VIEW_FLAT_CONTEXT *
				      flat_context,
				      _MOD_GL_VIEW_FLAT_GAME_CONTEXT *
				      game_context)
{
  _mod_gl_view_flat_game_context_clear_map (utils_context, flat_context,
					    &(game_context->map));
  _mod_gl_view_flat_game_context_clear_armies (utils_context, flat_context,
					       &(game_context->armies));
}

void
_mod_gl_view_flat_game_context_clear_map (MOD_GL_UTILS_CONTEXT *
					  utils_context,
					  _MOD_GL_VIEW_FLAT_CONTEXT *
					  flat_context,
					  _MOD_GL_VIEW_FLAT_GAME_CONTEXT_MAP *
					  game_context_map)
{
  mod_gl_utils_texture_array_clear (utils_context,
				    &(game_context_map->map_texture_array));
  memset (game_context_map, 0, sizeof (_MOD_GL_VIEW_FLAT_GAME_CONTEXT_MAP));
}

void
_mod_gl_view_flat_game_context_clear_armies (MOD_GL_UTILS_CONTEXT *
					     utils_context,
					     _MOD_GL_VIEW_FLAT_CONTEXT *
					     flat_context,
					     _MOD_GL_VIEW_FLAT_GAME_CONTEXT_ARMIES
					     * game_context_armies)
{
  int i;

  mod_gl_utils_surface_array_clear (utils_context,
				    &(game_context_armies->
				      armies_surface_array));
  for (i = 0; i < LW6MAP_MAX_DEPTH; ++i)
    {
      mod_gl_utils_texture_array_clear (utils_context,
					&(game_context_armies->
					  armies_texture_arrays[i]));
    }

  memset (game_context_armies, 0,
	  sizeof (_MOD_GL_VIEW_FLAT_GAME_CONTEXT_ARMIES));
}

int
_mod_gl_view_flat_game_context_update (MOD_GL_UTILS_CONTEXT *
				       utils_context,
				       _MOD_GL_VIEW_FLAT_CONTEXT *
				       flat_context,
				       _MOD_GL_VIEW_FLAT_GAME_CONTEXT *
				       game_context,
				       LW6MAP_MAP * map,
				       LW6KER_GAME_STATE * game_state,
				       LW6GFX_GAME_LOOK * game_look)
{
  int ret = 0;

  ret =
    _mod_gl_view_flat_game_context_update_map (utils_context, flat_context,
					       &(game_context->map), map)
    && _mod_gl_view_flat_game_context_update_armies (utils_context,
						     flat_context,
						     &(game_context->armies),
						     game_state, game_look);

  return ret;
}

int
_mod_gl_view_flat_game_context_update_map (MOD_GL_UTILS_CONTEXT *
					   utils_context,
					   _MOD_GL_VIEW_FLAT_CONTEXT *
					   flat_context,
					   _MOD_GL_VIEW_FLAT_GAME_CONTEXT_MAP
					   * game_context_map,
					   LW6MAP_MAP * map)
{
  int ret = 0;

  if (game_context_map->map_id == map->id && game_context_map->map == map)
    {
      ret = 1;			// nothing to do, up to date
    }
  else
    {
      _mod_gl_view_flat_game_context_clear_map (utils_context,
						flat_context,
						game_context_map);
      ret =
	_mod_gl_view_flat_game_context_init_map (utils_context, flat_context,
						 game_context_map, map);
    }

  return ret;
}

int
_mod_gl_view_flat_game_context_update_armies (MOD_GL_UTILS_CONTEXT *
					      utils_context,
					      _MOD_GL_VIEW_FLAT_CONTEXT *
					      flat_context,
					      _MOD_GL_VIEW_FLAT_GAME_CONTEXT_ARMIES
					      * game_context_armies,
					      LW6KER_GAME_STATE * game_state,
					      LW6GFX_GAME_LOOK * game_look)
{
  int ret = 0;

  if (game_context_armies->game_state_id == game_state->id &&
      game_context_armies->game_state == game_state)
    {
      ret = 1;			// nothing to do, up to date
    }
  else
    {
      _mod_gl_view_flat_game_context_clear_armies (utils_context,
						   flat_context,
						   game_context_armies);
      ret =
	_mod_gl_view_flat_game_context_init_armies (utils_context,
						    flat_context,
						    game_context_armies,
						    game_state, game_look);
    }

  return ret;
}
