/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <GL/glu.h>
#include <SDL/SDL_image.h>

#include "config.h"
#include "../../../gfx.h"
#include "../../../../cfg/cfg.h"
#include "gl-flat.h"
#include "gl-flat-internal.h"

#define CONST_FILE "gfx/gl/view/flat/const.xml"

static void
read_callback (void *callback_data, char *element, char *key, char *value)
{
  _MOD_GL_VIEW_FLAT_CONST_DATA *const_data;

  const_data = (_MOD_GL_VIEW_FLAT_CONST_DATA *) callback_data;

  if (!strcmp (element, "int"))
    {
      lw6cfg_read_xml_int (key, value, "tile-size-map",
			   &const_data->tile_size_map);
      lw6cfg_read_xml_int (key, value, "tile-size-armies",
			   &const_data->tile_size_armies);
    }

  if (!strcmp (element, "float"))
    {
      lw6cfg_read_xml_float (key, value, "cursor-size",
			     &const_data->cursor_size);
    }
}

static int
load_consts (MOD_GL_UTILS_CONTEXT * utils_context,
	     _MOD_GL_VIEW_FLAT_CONTEXT * flat_context)
{
  int ret = 0;
  char *const_file = NULL;

  const_file = lw6sys_find_data_file (CONST_FILE);

  if (const_file)
    {
      lw6sys_log (LW6SYS_LOG_INFO, "gfx-mod-gl", _("reading \"%s\""),
		  const_file);

      ret =
	lw6cfg_read_key_value_xml_file (const_file, read_callback,
					(void *) &(flat_context->const_data));

      LW6SYS_FREE (const_file);
    }

  return ret;
}

static void
unload_consts (MOD_GL_UTILS_CONTEXT * utils_context,
	       _MOD_GL_VIEW_FLAT_CONTEXT * flat_context)
{
  memset (&flat_context->const_data, 0,
	  sizeof (_MOD_GL_VIEW_FLAT_CONST_DATA));
}


/*
 * Putting all the load/unload functions together
 */
int
_mod_gl_view_flat_load_data (MOD_GL_UTILS_CONTEXT * utils_context,
			     _MOD_GL_VIEW_FLAT_CONTEXT * flat_context)
{
  return load_consts (utils_context, flat_context);
}

int
mod_gl_view_load_data (MOD_GL_UTILS_CONTEXT * utils_context,
		       void *flat_context)
{
  return _mod_gl_view_flat_load_data (utils_context,
				      (_MOD_GL_VIEW_FLAT_CONTEXT *)
				      flat_context);
}

void
_mod_gl_view_flat_unload_data (MOD_GL_UTILS_CONTEXT * utils_context,
			       _MOD_GL_VIEW_FLAT_CONTEXT * flat_context)
{
  unload_consts (utils_context, flat_context);
}

void
mod_gl_view_unload_data (MOD_GL_UTILS_CONTEXT * utils_context,
			 void *flat_context)
{
  _mod_gl_view_flat_unload_data (utils_context,
				 (_MOD_GL_VIEW_FLAT_CONTEXT *) flat_context);
}
