/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <GL/glu.h>

#include "config.h"
#include "../../mod-gl.h"
#include "gl-cylinder-internal.h"

#define SELECT_BUFFER_SIZE 1024

static void
draw_button_shape (MOD_GL_UTILS_CONTEXT * utils_context,
		   _MOD_GL_MENU_CYLINDER_CONTEXT * cylinder_context,
		   char *label, int i, int n, int name)
{
  glLoadName (name);
  _mod_gl_menu_cylinder_draw_cylinder (utils_context, cylinder_context,
				       GL_SELECT, i, n, 1.0f);
}

static int
process_select_hits (GLint select_hits,
		     GLuint select_buffer[SELECT_BUFFER_SIZE], int x, int y)
{
  int ret = -1;
  unsigned int i, j;
  GLuint names, *ptr;

  /*
   * We decide to walk all the array and keep the last value.
   * Note that we could look the first one and code could look simpler,
   * but for debugging purposes, it's easier to keep a track of
   * how to get all the values, with the lool & all fields.
   */
  ptr = (GLuint *) select_buffer;
  for (i = 0; i < select_hits; i++)
    {				// for each hit
      names = *ptr;
      ptr++;			// names
      ptr++;			// z1
      ptr++;			// z2
      for (j = 0; j < names; j++)
	{			// for each name
	  ret = (*ptr);
	  ptr++;		// name
	}
    }

  return ret;
}

int
_mod_gl_menu_cylinder_pick_item (MOD_GL_UTILS_CONTEXT * utils_context,
				 _MOD_GL_MENU_CYLINDER_CONTEXT *
				 cylinder_context, LW6GFX_MENU * menu,
				 int screen_x, int screen_y)
{
  int ret = -1;
  int i;
  LW6GFX_MENUITEM *menuitem;
  LW6GFX_MENU_STATE *menu_state;
  GLuint select_buffer[SELECT_BUFFER_SIZE];
  GLint select_hits;

  glSelectBuffer (SELECT_BUFFER_SIZE, select_buffer);
  glRenderMode (GL_SELECT);
  glInitNames ();
  glPushName (-1);

  mod_gl_utils_set_render_mode_3d_pick (utils_context, screen_x, screen_y);

  if (lw6sys_assoc_has_key (cylinder_context->menu_states, menu->id))
    {
      menu_state =
	(LW6GFX_MENU_STATE *) lw6sys_assoc_get (cylinder_context->menu_states,
						menu->id);
    }
  else
    {
      menu_state = lw6gfx_menu_state_new ();
      lw6sys_assoc_set (&(cylinder_context->menu_states), menu->id,
			(void *) menu_state);
      lw6gfx_menu_state_update (menu_state, menu,
				utils_context->const_data.
				menu_max_displayed_items);
    }

  for (i = 0; i < menu_state->nb_items_displayed; ++i)
    {
      menuitem = menu->items[i + menu_state->first_item_displayed];
      switch (menuitem->type)
	{
	case LW6GFX_MENUITEM_NONE:
	  break;
	case LW6GFX_MENUITEM_BUTTON:
	  draw_button_shape (utils_context,
			     cylinder_context,
			     menuitem->label,
			     i, menu_state->nb_items_displayed,
			     i + menu_state->first_item_displayed);
	  break;
	case LW6GFX_MENUITEM_EDIT:
	  break;
	case LW6GFX_MENUITEM_SLIDER:
	  break;
	default:
	  lw6sys_log (LW6SYS_LOG_WARNING, "gfx-mod-gl",
		      _("unknown menuitem type %d"), menuitem->type);
	}
    }

  select_hits = glRenderMode (GL_RENDER);
  ret = process_select_hits (select_hits, select_buffer, screen_x, screen_y);

  return ret;
}

int
mod_gl_menu_cylinder_pick_item (MOD_GL_UTILS_CONTEXT * utils_context,
				void *cylinder_context, LW6GFX_MENU * menu,
				int screen_x, int screen_y)
{
  return _mod_gl_menu_cylinder_pick_item (utils_context,
					  (_MOD_GL_MENU_CYLINDER_CONTEXT *)
					  cylinder_context, menu, screen_x,
					  screen_y);
}
