/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_MOD_GL_HUD_FLOATING_INTERNAL_H
#define LIQUIDWAR6GFX_MOD_GL_HUD_FLOATING_INTERNAL_H

#include <GL/gl.h>
#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>

#include "gl-floating.h"

typedef struct _MOD_GL_HUD_FLOATING_CONST_DATA_STRUCT
{
  float clock_x;
  float clock_y;
  float clock_w;
  float clock_h;
}
_MOD_GL_HUD_FLOATING_CONST_DATA;

typedef struct _MOD_GL_HUD_FLOATING_CONTEXT_STRUCT
{
  _MOD_GL_HUD_FLOATING_CONST_DATA const_data;
}
_MOD_GL_HUD_FLOATING_CONTEXT;

/*
 * In display.c
 */
extern void _mod_gl_hud_floating_display (MOD_GL_UTILS_CONTEXT *
					  utils_context,
					  _MOD_GL_HUD_FLOATING_CONTEXT
					  * floating_context,
					  LW6KER_GAME_STATE * game_state);
extern void _mod_gl_hud_floating_display_preview (MOD_GL_UTILS_CONTEXT *
						  utils_context,
						  _MOD_GL_HUD_FLOATING_CONTEXT
						  * floating_context);

/*
 * In data.c
 */
extern int _mod_gl_hud_floating_load_data (MOD_GL_UTILS_CONTEXT *
					   utils_context,
					   _MOD_GL_HUD_FLOATING_CONTEXT
					   * floating_context);
extern void _mod_gl_hud_floating_unload_data (MOD_GL_UTILS_CONTEXT *
					      utils_context,
					      _MOD_GL_HUD_FLOATING_CONTEXT
					      * floating_context);

/*
 * In setup.c
 */
extern _MOD_GL_HUD_FLOATING_CONTEXT
  * _mod_gl_hud_floating_init (MOD_GL_UTILS_CONTEXT * utils_context);
extern void _mod_gl_hud_floating_quit (MOD_GL_UTILS_CONTEXT *
				       utils_context,
				       _MOD_GL_HUD_FLOATING_CONTEXT *
				       floating_context);

#endif
