/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <GL/glu.h>
#include <SDL/SDL_image.h>

#include "config.h"
#include "../../../gfx.h"
#include "../../../../cfg/cfg.h"
#include "gl-floating.h"
#include "gl-floating-internal.h"

#define CONST_FILE "gfx/gl/hud/floating/const.xml"

static void
read_callback (void *callback_data, char *element, char *key, char *value)
{
  _MOD_GL_HUD_FLOATING_CONST_DATA *const_data;

  const_data = (_MOD_GL_HUD_FLOATING_CONST_DATA *) callback_data;

  if (!strcmp (element, "float"))
    {
      lw6cfg_read_xml_float (key, value, "clock-x", &const_data->clock_x);
      lw6cfg_read_xml_float (key, value, "clock-y", &const_data->clock_y);
      lw6cfg_read_xml_float (key, value, "clock-w", &const_data->clock_w);
      lw6cfg_read_xml_float (key, value, "clock-h", &const_data->clock_h);
    }
}

static int
load_consts (MOD_GL_UTILS_CONTEXT * utils_context,
	     _MOD_GL_HUD_FLOATING_CONTEXT * floating_context)
{
  int ret = 0;
  char *const_file = NULL;

  const_file = lw6sys_find_data_file (CONST_FILE);

  if (const_file)
    {
      lw6sys_log (LW6SYS_LOG_INFO, "gfx-mod-gl", _("reading \"%s\""),
		  const_file);

      ret =
	lw6cfg_read_key_value_xml_file (const_file, read_callback,
					(void *) &(floating_context->
						   const_data));

      LW6SYS_FREE (const_file);
    }

  utils_context->const_data.viewport_x = 0.0f;
  utils_context->const_data.viewport_y = 0.0f;
  utils_context->const_data.viewport_w = 1.0f;
  utils_context->const_data.viewport_h = 1.0f;

  return ret;
}

static void
unload_consts (MOD_GL_UTILS_CONTEXT * utils_context,
	       _MOD_GL_HUD_FLOATING_CONTEXT * floating_context)
{
  memset (&floating_context->const_data, 0,
	  sizeof (_MOD_GL_HUD_FLOATING_CONST_DATA));
}

/*
 * Putting all the load/unload functions together
 */
int
_mod_gl_hud_floating_load_data (MOD_GL_UTILS_CONTEXT * utils_context,
				_MOD_GL_HUD_FLOATING_CONTEXT *
				floating_context)
{
  return load_consts (utils_context, floating_context);
}

void
_mod_gl_hud_floating_unload_data (MOD_GL_UTILS_CONTEXT * utils_context,
				  _MOD_GL_HUD_FLOATING_CONTEXT *
				  floating_context)
{
  unload_consts (utils_context, floating_context);
}
