/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "config.h"
#include "../../../gfx.h"
#include "gl-fire.h"
#include "gl-fire-internal.h"

/*
 * Low-level SDL initialisation.
 */
_MOD_GL_BACKGROUND_FIRE_CONTEXT *
_mod_gl_background_fire_init (MOD_GL_UTILS_CONTEXT * utils_context)
{
  _MOD_GL_BACKGROUND_FIRE_CONTEXT *fire_context = NULL;

  lw6sys_log (LW6SYS_LOG_INFO, "gfx-mod-gl", _("init background/fire"));

  fire_context =
    (_MOD_GL_BACKGROUND_FIRE_CONTEXT *)
    LW6SYS_MALLOC (sizeof (_MOD_GL_BACKGROUND_FIRE_CONTEXT));
  if (!fire_context)
    {
      /*
       * No use to continue if this basic malloc fails...
       */
      exit (1);
    }

  memset (fire_context, 0, sizeof (_MOD_GL_BACKGROUND_FIRE_CONTEXT));


  if (!_mod_gl_background_fire_load_data (utils_context, fire_context))
    {
      LW6SYS_FREE (fire_context);
      fire_context = NULL;
    }

  return fire_context;
}

void *
mod_gl_background_fire_init (MOD_GL_UTILS_CONTEXT * utils_context)
{
  return (void *) _mod_gl_background_fire_init (utils_context);
}

/*
 * Ends-up all SDL stuff.
 */
void
_mod_gl_background_fire_quit (MOD_GL_UTILS_CONTEXT * utils_context,
			      _MOD_GL_BACKGROUND_FIRE_CONTEXT * fire_context)
{
  lw6sys_log (LW6SYS_LOG_INFO, "gfx-mod-gl", _("quit background/fire"));

  _mod_gl_background_fire_unload_data (utils_context, fire_context);
  LW6SYS_FREE (fire_context);
}

void
mod_gl_background_fire_quit (MOD_GL_UTILS_CONTEXT * utils_context,
			     void *fire_context)
{
  _mod_gl_background_fire_quit (utils_context,
				(_MOD_GL_BACKGROUND_FIRE_CONTEXT *)
				fire_context);
}
