/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "config.h"
#include "gfx.h"

/*
 * Creates a menu struct. Note that one needs to call set_item
 * afterwards to actually affect the different items.
 */
LW6GFX_MENU *
lw6gfx_menu_new (char *id, char *label, LW6GFX_MENU_TYPE type,
		 int selected_item, int nb_items)
{
  LW6GFX_MENU *menu = NULL;

  menu = (LW6GFX_MENU *) LW6SYS_CALLOC (sizeof (LW6GFX_MENU));

  if (menu)
    {
      menu->id = lw6sys_str_copy (id);
      menu->label = lw6sys_str_copy (label);
      menu->type = type;
      menu->selected_item = selected_item;
      menu->nb_items = nb_items;
      menu->items =
	(LW6GFX_MENUITEM **) LW6SYS_CALLOC (nb_items *
					    sizeof (LW6GFX_MENUITEM *));
      if (menu->items)
	{
	  //ok
	}
      else
	{
	  LW6SYS_FREE (menu);
	  menu = NULL;
	}
    }

  return menu;
}

/*
 * Frees a menu struct and all its menuitems.
 */
void
lw6gfx_menu_free (LW6GFX_MENU * menu)
{
  int i;

  if (menu)
    {
      if (menu->id)
	{
	  LW6SYS_FREE (menu->id);
	}
      if (menu->label)
	{
	  LW6SYS_FREE (menu->label);
	}
      if (menu->items)
	{
	  for (i = 0; i < menu->nb_items; ++i)
	    {
	      lw6gfx_menuitem_free (menu->items[i]);
	    }
	  LW6SYS_FREE (menu->items);
	}
      LW6SYS_FREE (menu);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "gfx", _("trying to free NULL menu"));
    }
}

/*
 * Affects a menuitem to a menu. Not that once affected, freeing
 * the menu will automatically free the associated menuitem.
 */
void
lw6gfx_menu_set_item (LW6GFX_MENU * menu, int i, LW6GFX_MENUITEM * menuitem)
{
  if (i >= 0 && i < menu->nb_items)
    {
      menu->items[i] = menuitem;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "gfx",
		  _("wrong menuitem index %d, nb_items is %d"), i,
		  menu->nb_items);
    }
}
