/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6DYN_H
#define LIQUIDWAR6DYN_H

#include <ltdl.h>

#include "../lw6-common.h"

#include "../sys/sys.h"

typedef struct LW6DYN_DL_HANDLE_STRUCT
{
  lt_dlhandle handle;
  char *library_path;
}
LW6DYN_DL_HANDLE;

/*
 * Functions in dl.c
 */
extern LW6DYN_DL_HANDLE *lw6dyn_dlopen_backend (char *top_level_lib,
						char *backend_name);
extern int lw6dyn_dlclose_backend (LW6DYN_DL_HANDLE * handle);
extern void *lw6dyn_dlsym (LW6DYN_DL_HANDLE * handle, char *func_name);

/*
 * Functions in path.c
 */
extern char *lw6dyn_path_find_backend (char *top_level_lib,
				       char *backend_name);

#endif
