/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <stdio.h>

#include "config.h"
#include "cfg.h"
#include "cfg-internal.h"

static void
write_option (void *func_data, char *key, void *value)
{
  FILE *f = (FILE *) func_data;
  char *str_value = (char *) value;

  fprintf (f, "  <option key=\"%s\" value=\"%s\" />\n", key, str_value);
}

int
_lw6cfg_save (_LW6CFG_CONTEXT * context, char *filename)
{
  int ret = 0;
  FILE *f;

  lw6sys_log (LW6SYS_LOG_INFO, "cfg", _("saving config to \"%s\""), filename);
  lw6sys_create_dir_for_file (filename);
  f = fopen (filename, "w");
  if (f)
    {
      fprintf (f, "<?xml version=\"1.0\"?>\n");
      fprintf (f, "<lw6cfgconfig>\n");
      lw6sys_assoc_map (context->options, write_option, (void *) f);
      fprintf (f, "</lw6cfgconfig>\n");
      fclose (f);
      ret = 1;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "cfg",
		  _("could not open file \"%s\" in write mode"), filename);
    }

  return ret;
}

int
lw6cfg_save (void *context, char *filename)
{
  return _lw6cfg_save ((_LW6CFG_CONTEXT *) context, filename);
}
